varying vec2 		texcoord;
uniform sampler2D 	tex,
					matTex,
					normalTex,
					depthTex;
uniform vec2		filterTaps[12];
varying vec2		VPOS;
uniform vec4		ambientColor;
uniform float 		reflMul;

vec4 decode(vec4 enc)
{
    vec2 fenc = enc.xy*4.0-2.0;
    float f = dot(fenc,fenc);
    float g = sqrt(1.0-f/4.0);
    vec4 n;
    n.xy = fenc.xy*g;
    n.z = 1.0-f/2.0;
	n.w=enc.w;
    return n;
}

void main()
{
	vec4 color=texture2D(tex, texcoord);
	
	vec4 mat=texture2D(matTex,texcoord.st);
	vec4 pos;
	pos.z=texture2D(depthTex,texcoord.st).r;
	pos.xy=VPOS.xy*-pos.z;
	float centerDepth = -pos.z;
	
	vec4 encoded=texture2D(normalTex,texcoord.st);
	float reflPow=encoded.z*16.0;
	vec3 N=decode(encoded).xyz;
	vec3 vdir=-normalize(pos.xyz);
	float F=min(reflPow,0.2)+(1.0-reflPow)*pow((1.0-dot(vdir,N.xyz)),5.0);
	
	vec4  	acc=color;
	vec4 	tapBlur;
	float glossisness=((1.0-mat.y)*60.0);//15.0);
	
	float totalContribution=1.0;
	float depthTolerance=20.0;//min(centerDepth*0.1,20.0);
	
	vec2 tccoords=texcoord+filterTaps[0]*glossisness;
	float d1=-texture2D(depthTex,tccoords).r;
	tapBlur=texture2D(tex,tccoords);
	float tapContribution = clamp(depthTolerance-abs(centerDepth-d1),0.0,1.0);
	acc += tapBlur*tapContribution;
	totalContribution += tapContribution;

	tccoords=texcoord+filterTaps[1]*glossisness;
	float d2=-texture2D(depthTex,tccoords).r;
	tapBlur=texture2D(tex,tccoords);
	tapContribution = clamp(depthTolerance-abs(centerDepth-d2),0.0,1.0);
	acc	+=tapBlur*tapContribution;
	totalContribution += tapContribution;
	
	tccoords=texcoord+filterTaps[2]*glossisness;
	float d3=-texture2D(depthTex,tccoords).r;
	tapBlur=texture2D(tex,tccoords);
	tapContribution = clamp(depthTolerance-abs(centerDepth-d3),0.0,1.0);
	acc	+=tapBlur*tapContribution;
	totalContribution += tapContribution;
	
	tccoords=texcoord+filterTaps[3]*glossisness;
	float d4=-texture2D(depthTex,tccoords).r;
	tapBlur=texture2D(tex,tccoords);
	tapContribution = clamp(depthTolerance-abs(centerDepth-d4),0.0,1.0);
	acc	+=tapBlur*tapContribution;
	totalContribution += tapContribution;
	
	tccoords=texcoord+filterTaps[4]*glossisness;
	float d5=-texture2D(depthTex,tccoords).r;
	tapBlur=texture2D(tex,tccoords);
	tapContribution = clamp(depthTolerance-abs(centerDepth-d5),0.0,1.0);
	acc	+=tapBlur*tapContribution;
	totalContribution += tapContribution;
	
	tccoords=texcoord+filterTaps[5]*glossisness;
	float d6=-texture2D(depthTex,tccoords).r;
	tapBlur=texture2D(tex,tccoords);
	tapContribution = clamp(depthTolerance-abs(centerDepth-d6),0.0,1.0);
	acc	+=tapBlur*tapContribution;
	totalContribution += tapContribution;
	
	tccoords=texcoord+filterTaps[6]*glossisness;
	float d7=-texture2D(depthTex,tccoords).r;
	tapBlur=texture2D(tex,tccoords);
	tapContribution = clamp(depthTolerance-abs(centerDepth-d7),0.0,1.0);
	acc	+=tapBlur*tapContribution;
	totalContribution += tapContribution;
	
	tccoords=texcoord+filterTaps[7]*glossisness;
	float d8=-texture2D(depthTex,tccoords).r;
	tapBlur=texture2D(tex,tccoords);
	tapContribution = clamp(depthTolerance-abs(centerDepth-d8),0.0,1.0);
	acc	+=tapBlur*tapContribution;
	totalContribution += tapContribution;
	
	tccoords=texcoord+filterTaps[8]*glossisness;
	float d9=-texture2D(depthTex,tccoords).r;
	tapBlur=texture2D(tex,tccoords);
	tapContribution = clamp(depthTolerance-abs(centerDepth-d9),0.0,1.0);
	acc	+=tapBlur*tapContribution;
	totalContribution += tapContribution;
	
	tccoords=texcoord+filterTaps[9]*glossisness;
	float d10=-texture2D(depthTex,tccoords).r;
	tapBlur=texture2D(tex,tccoords);
	tapContribution = clamp(depthTolerance-abs(centerDepth-d10),0.0,1.0);
	acc	+=tapBlur*tapContribution;
	totalContribution += tapContribution;
	
	tccoords=texcoord+filterTaps[10]*glossisness;
	float d11=-texture2D(depthTex,tccoords).r;
	tapBlur=texture2D(tex,tccoords);
	tapContribution = clamp(depthTolerance-abs(centerDepth-d11),0.0,1.0);
	acc	+=tapBlur*tapContribution;
	totalContribution += tapContribution;
	
	tccoords=texcoord+filterTaps[11]*glossisness;
	float d12=-texture2D(depthTex,tccoords).r;
	tapBlur=texture2D(tex,tccoords);
	tapContribution = clamp(depthTolerance-abs(centerDepth-d12),0.0,1.0);
	acc	+=tapBlur*tapContribution;
	totalContribution += tapContribution;
	
	vec4 finalColor = acc.rgba/totalContribution;
	finalColor.rgb = max(vec3(0.0),finalColor.rgb)*(reflPow*mat.y)*ambientColor.rgb*reflMul*F;
	gl_FragColor.rgb=finalColor.rgb;//*clamp(finalColor.a,0.0,1.0);
	gl_FragColor.a=clamp(finalColor.a,0.0,1.0);
	
/*	vec4 finalColor=color;
	finalColor.rgb *= (reflPow*mat.y);
	gl_FragColor.rgb=finalColor.rgb;//*clamp(finalColor.a,0.0,1.0);
	gl_FragColor.a=clamp(finalColor.a,0.0,1.0);*/
}